% A 2.3: Abtastung einer harmonischen Schwingung zur Demonstration von Aliasing
% bung Signalverarbeitung, 19.04.2011

clear % leeren des workspace
close all % alle plots schlieen
clc % leeren des comand window

tmin = 0;  % Startzeit [s]
tmax = 2;  % Endzeit [s]


f  = 10;   % Signalfrequenz [Hz]
f0 = 9;   % Abtastfrequenz [Hz]



tc = linspace(tmin,tmax,10000)'; % Pseudo-kontinuierlicher Zeitvektor in [sec]
yc = sin(2*pi*f*tc); % Kontinuierliches Signal

% hilft den plot direkt auf einer vernnfitgen Gre zu erzeugen
scrsz = get(0,'ScreenSize');
figure('Position',[1 scrsz(4)/4 scrsz(3) scrsz(4)/3])
hold on
% ursprgliches Signal
plot(tc,yc,'r','LineWidth',1.2)

T0 = 1/f0; % Abtastzeit [sec]


kmin = ceil(tmin / T0); % erster Abtastzeitpunkt
kmax = floor(tmax / T0); % letzter Abtastzpunkt
k    = kmin:kmax; % Diskreter Zeitvektor k = t/T0

% Abgetastetes Signal (einzelne Zeitpunkte k)
y  = sin(2*pi*f*k*T0);
plot(k*T0,y,'x--','markersize',10,'LineWidth',1.2)